/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.writers;

import eu.europa.ec.taxud.cesop.utils.LangUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CesopXmlWriter<T extends OutputStream>
implements AutoCloseable {
    private static final String INDENT_CHARS = "    ";
    private final T outputStream;
    private final XMLStreamWriter xmlStreamWriter;
    int indent = 0;
    boolean onEol = false;

    public CesopXmlWriter(T outputStream) throws XMLStreamException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
        this.outputStream = outputStream;
        this.xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8.name());
    }

    protected void writeNamespace() throws XMLStreamException {
        this.xmlStreamWriter.writeNamespace("cesop", "urn:ec.europa.eu:taxud:fiscalis:cesop:v1");
    }

    protected void writeStartDocument() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument();
    }

    protected void writeTag(QName qName, String value) throws XMLStreamException {
        this.writeTagWithAttributes(qName, value, null);
    }

    protected void writeAttribute(String name, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(name, value);
    }

    protected void writeTagWithAttributes(QName qName, String value, Map<String, String> attributes) throws XMLStreamException {
        this.writeStartElement(qName);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                this.xmlStreamWriter.writeAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        this.writeText(value);
        this.writeEndElement();
        this.writeEOL();
    }

    protected void writeTag(QName qName, boolean value) throws XMLStreamException {
        this.writeStartElement(qName);
        this.writeBoolean(value);
        this.writeEndElement();
        this.writeEOL();
    }

    protected void writeTag(QName qName, Integer value) throws XMLStreamException {
        this.writeStartElement(qName);
        this.writeInteger(value);
        this.writeEndElement();
        this.writeEOL();
    }

    protected void writeTagIfNotEmpty(String localName, String value) throws XMLStreamException {
        if (LangUtils.isNotBlank(value)) {
            this.writeTag(localName, value);
        }
    }

    protected void writeTagIfNotEmpty(String localName, Integer value) throws XMLStreamException {
        if (value != null) {
            this.writeTag(localName, value);
        }
    }

    protected void writeTag(String localName, String value) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeText(value);
        this.writeEndElement();
        this.writeEOL();
    }

    protected void writeTag(String localName, Integer value) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeInteger(value);
        this.writeEndElement();
        this.writeEOL();
    }

    protected void writeTag(String localName, Long value) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeLong(value);
        this.writeEndElement();
        this.writeEOL();
    }

    protected void writeStartElement(QName qName) throws XMLStreamException {
        this.writeIndentIfNeeded();
        this.xmlStreamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
        ++this.indent;
    }

    protected void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndentIfNeeded();
        this.xmlStreamWriter.writeStartElement(localName);
        ++this.indent;
    }

    protected void writeEndElement() throws XMLStreamException {
        --this.indent;
        this.writeIndentIfNeeded();
        this.xmlStreamWriter.writeEndElement();
    }

    protected void writeText(String characters) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(characters);
    }

    protected void writeBoolean(boolean value) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(Boolean.toString(value));
    }

    protected void writeInteger(Integer value) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(Integer.toString(value));
    }

    protected void writeLong(Long value) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(Long.toString(value));
    }

    protected void writeEOL() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters("\n");
        this.onEol = true;
    }

    protected void writeIndentIfNeeded() throws XMLStreamException {
        if (!this.onEol) {
            return;
        }
        for (int i = 0; i < this.indent; ++i) {
            this.xmlStreamWriter.writeCharacters(INDENT_CHARS);
        }
        this.onEol = false;
    }

    protected void flush() throws XMLStreamException {
        this.xmlStreamWriter.flush();
    }

    public T getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        this.xmlStreamWriter.close();
        ((OutputStream)this.outputStream).close();
    }
}

